 /****** Object:  UserDefinedFunction [dbo].[UFD_BUSCA_PRECO_PRODUTO]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BUSCA_PRECO_PRODUTO]') 
			AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_BUSCA_PRECO_PRODUTO]
GO
  
--select * from UFD_BUSCA_PRECO_PRODUTO 1,998,44147,0,2,12
CREATE FUNCTION [dbo].[UFD_BUSCA_PRECO_PRODUTO](@CD_EMP	 INT
													,@CD_FILIAL  INT
													,@CD_PROD	 INT
													,@TIPO_PRECO INT=0
													,@TP_DEST	INT=0
													,@CD_DEST	INT=0 
													) 
RETURNS MONEY WITH ENCRYPTION AS
BEGIN

-- @TP_DEST
-- 0 - Cliente
-- 1 - Fornecedor 
-- 2 - Filial

/*

DECLARE @FILIAL INT, @PROD INT 
SET @FILIAL =15
SET @PROD =1197

SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,0,0,0) VLR, 'CUSTO MEDIO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,1,0,0) VLR, 'CUSTO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,2,0,0) VLR, 'COMPRA' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,3,0,0) VLR, 'CUSTO GRUPO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,4,0,0) VLR, 'COMPRA GRUPO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,5,0,0) VLR, 'FABRICA' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,6,0,0) VLR, 'VENDA' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,7,0,0) VLR, 'OFERTA' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,8,0,0) VLR, 'OP LOGISTICO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,9,0,0) VLR, 'QUALQUER PRECO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,10,0,0) VLR, 'ULT SAI NF' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,11,0,0) VLR, 'ULT ENT NF' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,12,0,0) VLR, 'ULT ECF' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,13,0,0) VLR, 'FRANQUIA' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,14,2,5) VLR, 'RESSUPRIMENTO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,15,2,5) VLR, 'RESSUP A CUSTO MEDIO' TIPO
UNION ALL SELECT DBO.UFD_BUSCA_PRECO_PRODUTO (1,@FILIAL,@PROD,16,2,5)  VLR , 'PRECO COM GROSS  UP' TIPO
 
*/
	--0 Custo mdio
	--1	Custo
	--2 Compra
	--3 Custo Grupo
	--4 Compra Grupo
	--5 Fabrica
	--6 Venda
	--7 Oferta
	--8 Operador Logistico
	--9 Qualquer preo
	-- 10 Ultima NF sai
	-- 11 Ultima NF ent
	-- 12 Ultima PDV
	-- 13 Franquia
	-- 14 Ressuprimento
	-- 15 Ressuprimento a Custo MEdio
	-- 16 Gross up
	-- 17 Vlr Preco Transf. Custo Origem.

	DECLARE @VLR_PROD	MONEY 
	DECLARE @ID		INT
	DECLARE @Step	INT
	
	set @Step =-1;
	set @VLR_PROD = 0;

	--0 Custo medio
	IF @TIPO_PRECO in(0,9) 
	begin 
		CustoMedio:
		set @Step =0;
		--SET @VLR_PROD =	ISNULL(dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (@CD_EMP,@CD_FILIAL,@CD_PROD,getdate(),0),0)   
		SET @VLR_PROD =	 ISNULL((SELECT TOP 1  VLR_CUSTO_MD
								  FROM  EST_PROD_CPL 
								  WHERE 
									CD_EMP		= @CD_EMP AND 
									CD_FILIAL	= @CD_FILIAL AND 
									CD_PROD		= @CD_PROD),0); 

		IF (@TIPO_PRECO=0 or @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	 
	--1 Custo
	IF @TIPO_PRECO in(1,9)
	begin 
		Custo:
		set @Step =1;
		SET @VLR_PROD =	 ISNULL((SELECT TOP 1  VLR_CUSTO 
								  FROM  EST_PROD_CPL 
								  WHERE 
									CD_EMP		= @CD_EMP AND 
									CD_FILIAL	= @CD_FILIAL AND 
									CD_PROD		= @CD_PROD),0); 
									 
		IF (@TIPO_PRECO=1 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end

	--2 Compra
	IF @TIPO_PRECO in(2,9)
	begin
		Compra:	
		set @Step =2;
		SET @ID =ISNULL((SELECT CD_CTR_GRP FROM EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL
								WHERE  CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL),0);

		SET @VLR_PROD =	ISNULL((SELECT TOP 1 VLR_FORN FROM
									EST_PROD_PRECO_TBL
								 WHERE     
									CD_EMP = @CD_EMP 
									AND CD_PROD = @CD_PROD
									AND CD_CTR_GRP = @ID ),0)
		if @VLR_PROD = 0
		begin
		SET @VLR_PROD =	 ISNULL((SELECT TOP 1  VLR_COMPRA
								  FROM  EST_PROD_CPL 
								  WHERE 
									CD_EMP		= @CD_EMP AND 
									CD_FILIAL	= @CD_FILIAL AND 
									CD_PROD		= @CD_PROD),0); 
		end

		if @VLR_PROD = 0
		begin
			SET @VLR_PROD =	 ISNULL((SELECT TOP 1 VLR_COMPRA_GRP FROM  EST_PROD
										WHERE   CD_EMP		= @CD_EMP 
											AND CD_PROD		= @CD_PROD),0);
		 
		end

		IF (@TIPO_PRECO=2 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	
	--3 Custo Grupo
	IF @TIPO_PRECO in(3,9)
	begin 
		CustoGrupo:
		set @Step =3;
		SET @VLR_PROD =	 ISNULL((SELECT TOP 1 VLR_CUSTO_GRP FROM  EST_PROD  
										WHERE   CD_EMP		= @CD_EMP 
											AND CD_PROD		= @CD_PROD),0);
											 
		IF (@TIPO_PRECO=3 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end 
  
	--4 Compra Grupo
	IF @TIPO_PRECO in(4,9)
	begin 
		CompraGrupo:
		set @Step =4;
		SET @VLR_PROD =	 ISNULL((SELECT TOP 1 VLR_COMPRA_GRP FROM  EST_PROD
										WHERE   CD_EMP		= @CD_EMP 
											AND CD_PROD		= @CD_PROD),0);
 
		IF (@TIPO_PRECO=4 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end

	--5 Fabrica
	IF @TIPO_PRECO in(5,9)
	begin 
		Fabrica:
		set @Step =5;
		SET @ID =ISNULL((SELECT CD_CTR_GRP FROM EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL
								WHERE  CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL),0);

		SET @VLR_PROD =	ISNULL((SELECT TOP 1 VLR_FORN FROM
									EST_PROD_PRECO_TBL
								 WHERE     
									CD_EMP = @CD_EMP 
									AND CD_PROD = @CD_PROD
									AND CD_CTR_GRP = @ID ),0)
		IF (@TIPO_PRECO=5 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	
	--6 Venda
	IF @TIPO_PRECO in(6,9)
	begin 
		Venda:
		set @Step =6;
		SET @VLR_PROD =	ISNULL((SELECT TOP 1 VLR_TABELA
								 FROM
									EST_PROD_PRECO 
								 WHERE     
									CD_EMP = @CD_EMP 
									AND CD_PROD = @CD_PROD
									AND CD_FILIAL = @CD_FILIAL),0);
		IF (@TIPO_PRECO=6 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	
	--7 Oferta
	IF @TIPO_PRECO in(7,9)
	begin 
		Oferta:
		set @Step =7;
		SET @VLR_PROD =	ISNULL((SELECT TOP 1 VLR_OFERTA
								 FROM
									EST_PROD_PRECO 
								 WHERE     
									CD_EMP = @CD_EMP 
									AND CD_PROD = @CD_PROD
									AND CD_FILIAL = @CD_FILIAL),0);
		IF (@TIPO_PRECO=7 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	 
	--8 Operador Logistico
	IF @TIPO_PRECO in(8,9)
	begin 
		OperadorLogistico:
		set @Step =8;
		SET @VLR_PROD =	 ISNULL((SELECT  TOP 1   VLR_PRECO_OPERADOR_LOG FROM  EST_PROD
										WHERE   CD_EMP		= @CD_EMP 
											AND CD_PROD		= @CD_PROD),0);
		
		IF (@TIPO_PRECO=8 or  @VLR_PROD>0)
		begin
			goto Saida
		end 
	end

	-- 10 Ultima NF sai
	IF @TIPO_PRECO in(10,9)
	begin 
		UltNFSai:
		set @Step =10;
		SET @VLR_PROD = ISNULL((SELECT   TOP 1      
	   									VLR_IT
		   						  FROM
			   							EST_NF_SAI_IT
				   				  WHERE 
					   					CD_EMP = @CD_EMP
						   				AND CD_FILIAL = @CD_FILIAL
   										AND CD_PROD = @CD_PROD
	   									AND CD_NF = (SELECT 
		   													MAX(DISTINCT CD_NF) AS CD_NF
			   											FROM         
				   											EST_NF_SAI_IT
					      								WHERE     
						   									CD_EMP = @CD_EMP
							   								AND CD_FILIAL = @CD_FILIAL
															AND CD_PROD = @CD_PROD)),0)		 	
		IF (@TIPO_PRECO=10 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end
	 
	-- 11 Ultima NF ent
	IF @TIPO_PRECO in(11,9)
	begin 
	   UltNFEnt:
	   set @Step =11;
	   SET @VLR_PROD = ISNULL( (SELECT TOP 1        
	   							VLR_IT
		   				  FROM
			   					EST_NF_ENT_IT
				   		  WHERE 
					   			CD_EMP = @CD_EMP
						   		AND CD_FILIAL = @CD_FILIAL
   								AND CD_PROD = @CD_PROD
	   							AND CD_NF = (SELECT 
		   											MAX(DISTINCT CD_NF) AS CD_NF
			   									FROM         
				   									EST_NF_ENT_IT
					      						WHERE     
						   							CD_EMP = @CD_EMP
							   						AND CD_FILIAL = @CD_FILIAL
										   AND CD_PROD = @CD_PROD))	,0)				 	
	  	IF (@TIPO_PRECO=11 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end

	-- 12 Ultima PDV
	IF @TIPO_PRECO in(12,9)
	begin 
		UltPDV:	   
		set @Step =12;
		SET @VLR_PROD = ISNULL( (SELECT TOP 1   
	   								VLR_IT
		   						FROM PDV_VD_IT
				   				WHERE 
					   				CD_EMP = @CD_EMP
						   			AND CD_FILIAL  = @CD_FILIAL
   									AND CD_PROD		= @CD_PROD
	   								AND CD_VD = (SELECT 
		   												MAX(DISTINCT CD_VD) AS CD_VD
			   										FROM         
				   										PDV_VD_IT
					      							WHERE     
						   								CD_EMP = @CD_EMP
							   							AND CD_FILIAL = @CD_FILIAL
														AND CD_PROD = @CD_PROD))	,0)				 	
	  	IF (@TIPO_PRECO=12 or  @VLR_PROD>0)
		begin
			goto Saida
		end
	end

	--13 Franquia
	IF @TIPO_PRECO in(13,9)
	begin 
		Franquia:
		set @Step =13;
		SET @VLR_PROD =	 ISNULL((SELECT  TOP 1  VLR_PRECO_FRANQUIA FROM  EST_PROD
										WHERE   CD_EMP		= @CD_EMP 
											AND CD_PROD		= @CD_PROD),0);
		
		IF (@TIPO_PRECO=13 or  @VLR_PROD>0)
		begin
			goto Saida
		end 
	end
	  
	--14 Ressuprimento 
	IF @TIPO_PRECO in(14,15,9)
	begin 
	 
		Ressuprimento:  
		if @TP_DEST=2 --Filial >> Busca preo de tabela de transf. ressup.
		begin
		    --Deposito principal
			set @VLR_PROD=ISNULL((SELECT 
										MIN(B.VLR_TRANSF)
									FROM 
										PRC_FILIAL_DEPOSITO D
										JOIN GLB_CONFIG_PRECO_RESSUP A ON 
										D.CD_CTR_DEPO =A.CD_CTR_DEPO
										JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD B ON 
										A.CD_CONFIG = B.CD_CONFIG
										JOIN GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL C ON 
										A.CD_CONFIG = C.CD_CONFIG
									WHERE
										D.CD_EMP=@CD_EMP
										AND D.CD_FILIAL = @CD_FILIAL--FILIAL DEPOSITO PRINCIPAL
										AND C.CD_FILIAL = @CD_DEST-- FILIAL DESTINO/CLIENTE
										AND B.CD_PROD	= @CD_PROD),0)

			--Analisando se o deposito e o auxiliar para tambem usar o mesmo valor
			IF @VLR_PROD=0
			begin
				set @VLR_PROD=ISNULL((SELECT 
								MIN(B.VLR_TRANSF)
							FROM 
								PRC_FILIAL_DEPOSITO_AUXILIAR D
								JOIN GLB_CONFIG_PRECO_RESSUP A ON 
								D.CD_CTR_DEPO =A.CD_CTR_DEPO
								JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD B ON 
								A.CD_CONFIG = B.CD_CONFIG
								JOIN GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL C ON 
								A.CD_CONFIG = C.CD_CONFIG
							WHERE
								D.CD_EMP=@CD_EMP
								AND D.CD_FILIAL_DEPO_AUX = @CD_FILIAL--FILIAL DEPOSITO AUXILIAR
								AND C.CD_FILIAL = @CD_DEST-- FILIAL DESTINO/CLIENTE
								AND B.CD_PROD	= @CD_PROD),0)
			end
		end
	
		--CustoMedio
		IF isnull(@VLR_PROD,0)=0
		BEGIN 
			if @Step=-1 
				Goto CustoMedio;
			if @Step=0 
			  set @Step=-1
		end  

		--Custo 
		IF isnull(@VLR_PROD,0)=0
		BEGIN 
			if @Step=-1
				Goto Custo;
			if @Step=1
			  set @Step=-1
		end   

		--Compra
		IF isnull(@VLR_PROD,0)=0
		BEGIN 
			if @Step=-1
				Goto Compra;
			if @Step=2 
			  set @Step=-1
		end   
		
		--CustoGrupo 
		IF isnull(@VLR_PROD,0)=0
		BEGIN  
			if @Step=-1
				Goto CustoGrupo;
			if @Step=3
				set @Step=-1
		end   

		--CompraGrupo 
		IF isnull(@VLR_PROD,0)=0
		BEGIN  
			if @Step=-1
				Goto CompraGrupo;
			if @Step=4 
				set @Step=-1
		end   
		--Operador Logistico 
		IF isnull(@VLR_PROD,0)=0
		begin 
			if @Step=-1
				Goto OperadorLogistico;
			if @Step=8 
				set @Step=-1
		end   

		IF (@TIPO_PRECO in(14,15) or @VLR_PROD>0)
		begin
			goto Saida
		end
	end

	--14 Ressuprimento 
	IF @TIPO_PRECO= 17
	begin 
		--Deposito principal
		set @VLR_PROD=ISNULL((SELECT 
									MIN(B.VLR_CUSTO_IT)
								FROM 
									PRC_FILIAL_DEPOSITO D
									JOIN GLB_CONFIG_PRECO_RESSUP A ON 
									D.CD_CTR_DEPO =A.CD_CTR_DEPO
									JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD B ON 
									A.CD_CONFIG = B.CD_CONFIG
									JOIN GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL C ON 
									A.CD_CONFIG = C.CD_CONFIG
								WHERE
									D.CD_EMP=@CD_EMP
									AND D.CD_FILIAL = @CD_FILIAL--Filial deposito principal
									AND C.CD_FILIAL = @CD_DEST	-- Filial destino/cliente
									AND B.CD_PROD	= @CD_PROD),0)

		--Analisando se o deposito e o auxiliar para tambem usar o mesmo valor
		IF @VLR_PROD=0
		begin
			set @VLR_PROD=ISNULL((SELECT 
							MIN(B.VLR_CUSTO_IT)
						FROM 
							PRC_FILIAL_DEPOSITO_AUXILIAR D
							JOIN GLB_CONFIG_PRECO_RESSUP A ON 
							D.CD_CTR_DEPO =A.CD_CTR_DEPO
							JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD B ON 
							A.CD_CONFIG = B.CD_CONFIG
							JOIN GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL C ON 
							A.CD_CONFIG = C.CD_CONFIG
						WHERE
							D.CD_EMP=@CD_EMP
							AND D.CD_FILIAL_DEPO_AUX = @CD_FILIAL--FILIAL DEPOSITO AUXILIAR
							AND C.CD_FILIAL = @CD_DEST-- FILIAL DESTINO/CLIENTE
							AND B.CD_PROD	= @CD_PROD),0)
		end
	end


	--Gross up
	IF (@TIPO_PRECO =16 )
		begin 
			SET @VLR_PROD = dbo.UFD_BUSCA_PRECO_PRODUTO_GROSS_UP (@CD_EMP,@CD_FILIAL,@CD_PROD,@TIPO_PRECO,@TP_DEST,@CD_DEST,0);
						goto Saida
		end

		 

Saida:
	RETURN (ISNULL(@VLR_PROD,0))

end

 